<?php
class Telegram{
    public $token;
    public $db;

    public function __construct($token,$dbname, $dbuser, $dbpass){
        $this->token = $token;
        $this->db = new PDO("mysql:host=localhost;dbname=$dbname",$dbuser,$dbpass, 
        array(PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8") );
    }
    public function getUpdate(){
        return json_decode(file_get_contents("php://input"));
    }
    public function sendMessage($userid,$text, $keyboard = null){
        $url = "https://api.telegram.org/bot".$this->token."/sendMessage";
        
        $fields = [
            'chat_id' => $userid,
            'text' => $text,
            //'disable_web_page_preview' => true,
            //'disable_notification' => true,
            //'parse_mode' => $mod
        ];
        if($keyboard != null ) $fields['reply_markup'] = $this->makeMenu($keyboard);
        return $this->exeCurl($url,$fields);
    }
    public function sendPhoto($userid,$photo,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendPhoto";
        
        $fields = [
            'chat_id' => $userid,
            'photo' => $photo,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendVoice($userid,$voice,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendVoice";
        
        $fields = [
            'chat_id' => $userid,
            'voice' => $voice,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendAudio($userid,$audio,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendAudio";
        
        $fields = [
            'chat_id' => $userid,
            'audio' => $audio,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendVideo($userid,$video,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendVideo";
        
        $fields = [
            'chat_id' => $userid,
            'video' => $video,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendVideoNote($userid,$video,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendVideoNote";
        
        $fields = [
            'chat_id' => $userid,
            'video_note' => $video,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendDocument($userid,$document,$caption = ''){
        $url = "https://api.telegram.org/bot".$this->token."/sendDocument";
        
        $fields = [
            'chat_id' => $userid,
            'document' => $document,
            'caption' => $caption
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendAction($userid,$action){
        $url = "https://api.telegram.org/bot".$this->token."/sendAction";
        
        $fields = [
            'chat_id' => $userid,
            'action' => $action,
        ];
        return $this->exeCurl($url,$fields);
    }
    public function sendPoll($userid,$question,$answer){
        $fields = [
            'chat_id' => $userid,
            'question' => $question,
            'options' => json_encode($answer)
        ];
        return $this->executeCurl('sendPoll',$fields);
    }
    public function sendMediaGroup($userid,$media){
        $fields = [
            'chat_id' => $userid,
            'media' => json_encode($media)
        ];
        return $this->executeCurl('sendMediaGroup',$fields);
    }
    public function ForceReply($userid,$text){
        $fields = [
            'chat_id' => $userid,
            'text' => $text,
            'reply_markup' => json_encode([
                'force_reply' => true,
                'selective' => true
            ])
        ];
        return $this->executeCurl('sendMessage',$fields);
    }
    public function sendInline($userid,$text,$method,$keyboard){
        $fields = [
            'chat_id' => $userid,
            'text' => $text,
            'reply_markup' => json_encode([
                'inline_keyboard' => $keyboard
            ])
        ];
        return $this->executeCurl($method,$fields);
    }
    public function answerCallbackQuery($cid,$text,$alert = true){
        $fields = [
            'callback_query_id' => $cid,
            'text' => $text,
            'show_alert' => $alert
        ];
        return $this->executeCurl('answerCallbackQuery',$fields);
    }
    public function getChatMember($chatid,$userid){
        $fields = [
            'chat_id' => $chatid,
            'user_id' => $userid,
        ];
        $result = $this->executeCurl('getChatMember',$fields);
        return $result->result->status;
    }
    public function genRefCode($userid){
        $time = time();
        return substr(md5("$userid.$time"), 0, 10);
    }
    public function makeMenu($keyboard){
        $kekyboard = [
            'keyboard' => $keyboard,
            'resize_keyboard' => true,
            'one_time_keyboard' => false,
            'selective' => true
        ];
        return json_encode($kekyboard);
    }
    public function formatBytes($size){
        $base = log($size) / log(1024);
        $suffix = array("", "KB", "MB", "GB", "TB");
        $f_base = floor($base);
        return round(pow(1024, $base - floor($base)), 1) . $suffix[$f_base];
    }
    public function exeCurl($url,$fields = []){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $content = curl_exec($ch);
        curl_close($ch);
        return json_decode($content);
    }
    public function executeCurl($method,$fields = []){
        $url = "https://api.telegram.org/bot".$this->token."/$method";
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($fields));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $content = curl_exec($ch);
        curl_close($ch);
        return json_decode($content);
    }
}
?>